__PURE_version = 3.11
__PURE_fork = "pure"
ac.debug(">>> Pure Gamma WFX",string.format('v%.3f', __PURE_version))
ac.debug(">>> CSP Version", ac.getPatchVersion())



function _d(v)
    ac.debug("---",v)
    return v
end

___PURE___dev_version = false

___TEXTURE__QUALITY = render.TextureFormat.R16G16B16A16.Float
--___TEXTURE__QUALITY = render.TextureFormat.R32G32B32A32.Float


--[[
local _l_pure_err_list = {}
function PURE_ERR(header_txt, msg_txt)
    local found = 0
    for i=1,#_l_pure_err_list do
        if _l_pure_err_list[i].header == header_txt then
            found = i
            break
        end
    end
    if found>0 then
        _l_pure_err_list[found].msg = msg_txt
    else
        table.insert(_l_pure_err_list,{header=header_txt, msg=msg_txt})
    end
end
function PURE_ERR_update(dt)
    if #_l_pure_err_list>0 then
        __PURE__STATE:setString("err.header", _l_pure_err_list[1].header)
        __PURE__STATE:setString("err.msg", _l_pure_err_list[1].msg)
        table.remove(_l_pure_err_list, 1)
    else
        __PURE__STATE:setString("err.header", "")
        __PURE__STATE:setString("err.msg", "")
    end
end
]]
function PURE_ERR(header_txt, msg_txt)
    ac.debug(header_txt, msg_txt)
end

function get__dirname()
    if ac.dirname then
        return ac.dirname()
    else
        return "assettocorsa\\extension\\weather\\pure"
    end
end

-- get CSP version
__CSP_version = 0
if ac['getPatchVersionCode'] ~= nil then __CSP_version = ac.getPatchVersionCode() end

--[[
for k,v in pairs(ac) do
    if type(v) == "function" then
        ac.debug("##"..k, v)
    end
end
]]



local __CSP__wrong_version__ = false
__CSP__minimum_version = { 2639, "0.2.0" }

if __CSP_version < __CSP__minimum_version[1] then
  __CSP__wrong_version__ = true
end

--__PURE__ScriptSettings = ac.INIConfig.scriptSettings():mapSection('POSTPROCESSING', {
--    LIGHTWEIGHT_REPLACEMENT = false,
--})








__PURE__ScriptSettings = ac.INIConfig.scriptSettings():mapConfig({
    LINEAR_COLOR_SPACE = {
      ENABLED = false,
      DEV_MODE = false
    },
    POSTPROCESSING = {
      LIGHTWEIGHT_REPLACEMENT = false,
      --FILM_GRAIN = false
    },
    PERFORMANCE = {
        ECO = false,
    },
})

__ECO__ = __PURE__ScriptSettings.PERFORMANCE.ECO

__pure__path = get__dirname()
__pure__render_path = __pure__path.."\\render\\"
__pure__path_AC_root = ""
__pure__custom_ldr_effects_path = ac.getFolder(ac.FolderID.ExtRoot).."/config-ext/PureLdrEffects/"
__pure__custom_hdr_effects_path = ac.getFolder(ac.FolderID.ExtRoot).."/config-ext/PureHdrEffects/"
__AC__Root = ac.getFolder(ac.FolderID.Root)

-- build a path string to know the location relative to the ac root folder
local tmp_path = {}
for str in string.gmatch(__pure__path, "([^\\]+)") do
    table.insert(tmp_path, str)
end
local tmp_path_ext_pos = 0
for i=1,#tmp_path do if tmp_path[i]=="extension" then tmp_path_ext_pos=i break end end
if tmp_path_ext_pos > 1 then
    for i=tmp_path_ext_pos, #tmp_path do
        __pure__path_AC_root = __pure__path_AC_root.."\\"..tmp_path[i]
    end
end



function ___reset__Pure___(msg, remain_textures)
    -- set the time of the reset in the backup memeory
    msg = msg or "___reset__Pure___"
    file_write(__pure__path.."\\reset_dummy.lua","w+", msg)
end

function __PURE__getSim()
    return __AC_SIM
end



local _l_menu_open = false
function MENU_IS_OPEN()
    return _l_menu_open
end



_l_PURE_PILOT_TONE = nil
_l_PURE_PILOT_TONE_update = os.clock()
smoothingMgr = nil

local frames_before_load = 0

if not __CSP__wrong_version__ then

    __AC_SIM = nil

    local _l_smooth_times = {}
    local _l_debug_times = false

    local _l_pure_loaded = false
    local function load_pure()

        dofile (__pure__path.."\\utils\\utils_csp_backwards_compatibility.lua")
        dofile (__pure__path.."\\pure_globals.lua")


        -- saves settings temporaly in the RAM
        dofile (__pure__path.."\\utils\\utils_memory_backup.lua")
        dofile (__pure__path.."\\utils\\utils_lua.lua")

        dofile (__pure__path.."\\utils\\utils_smoothing.lua")
        smoothingMgr = SmoothMgr()

        for i=1, 20 do
            _l_smooth_times[i] = smoothingMgr:new(1,1)
            _l_smooth_times[i]:force(0)
        end

        __execution_time_long = smoothingMgr:new(0.1, 0.1)
        __execution_time_short = smoothingMgr:new(1, 1)
        __execution_time_long:force(0.00035)
        __execution_time_short:force(0.00035)

        -- fast Lookup tables
        dofile (__pure__path.."\\utils\\utils_LUT.lua")
        dofile (__pure__path.."\\utils\\utils_basics.lua")
        -- fast communikation via ac.connect
        dofile (__pure__path.."\\utils\\utils_connect.lua")
        -- a library to send states via ac.connect
        dofile (__pure__path.."\\utils\\utils_state.lua")

        dofile (__pure__path.."\\utils\\utils_state.lua")

        -- some libraries to store and load big datsets
        dofile (__pure__path.."\\utils\\utils_json.lua")

        load_script_file_sys(__pure__path.."\\utils\\utils_import.json")
        --dofile (__pure__path.."\\utils\\__utils_import.lua")

        -- Shader shader render / core functions
        -- initialize before config, to add config parameters or states
        dofile (__pure__path.."\\pure_render.lua")
        dofile (__pure__render_path.."render__list.lua")

        -- custom filters HDR + LDR
        dofile (__pure__path.."\\pp\\custom_filters.lua")

        -- defines Pure's monitoring states
        dofile (__pure__path.."\\pure_state.lua")
        -- Lua Scriptable filters bridge
        dofile (__pure__path.."\\pure_PPstate.lua")
        -- Pure settings functions
        dofile (__pure__path.."\\pure_config.lua")
        -- Pure Planner functions
        --dofile (__pure__path.."\\pure_planner.lua")

        repeat
            -- wait until config system is initialized
        until __PURE__update_config(0)


        -- optimization utils
        dofile (__pure__path.."\\utils\\utils_cpu.lua")

        -- get Sim and Car, manage AI headlights
        dofile (__pure__path.."\\pure_ai.lua")
        -- Camera functions
        dofile (__pure__path.."\\pure_camera.lua")
        -- sun, moon position and light source calculation
        dofile (__pure__path.."\\pure_stellar.lua")
        -- load track settings
        dofile (__pure__path.."\\pure_track.lua")
        ac.debug(">>> Track", __PURE__track_ID)
        -- generates the world graphics
        dofile (__pure__path.."\\pure_world.lua")
        -- manages the weather transitions
        dofile (__pure__path.."\\pure_weather.lua")
        -- audio stuff
        dofile (__pure__path.."\\pure_audio.lua")
        -- manages between Pure and Scripts functions 
        dofile (__pure__path.."\\pure_sharing.lua")
        -- Script functions
        dofile (__pure__path.."\\pure_script.lua")
        -- Script tools functions
        dofile (__pure__path.."\\script\\script_tools.lua")
        -- exposure control
        dofile (__pure__path.."\\exposure\\pure_exposure.lua")
        -- main PostProcessing functions
        dofile (__pure__path.."\\pp\\postprocessing.lua")
        dofile (__pure__path.."\\pp\\tonemapping.lua")
        dofile (__pure__path.."\\pure_pp.lua")
        -- run the sdk function junktions
        dofile (__pure__path.."\\sdk\\pure_sdk.lua")

        -- Initialize weather variable! They could be used in shaders too!
        cc__init_weather_variables()

        __PURE__initialize_render()
        __PURE__init_AI()
        -- initialize ppf script after all libraries are loaded
        --if not __BEFORE__VR__RESET__ then
        initPPScript()

        --end

        if file_exists(__pure__path.."\\test_ground\\test_ground.lua") then
            dofile (__pure__path.."\\test_ground\\test_ground.lua")
        end
        
        if __PURE__get_config("debug.memory") then

            local gcSmooth = 0
            local gcRuns = 0
            local gcLast = 0
            function runGC()
                local before = collectgarbage('count')
                collectgarbage()
                gcSmooth = math.applyLag(gcSmooth, before - collectgarbage('count'), gcRuns < 50 and 0.9 or 0.995, 0.05)
                gcRuns = gcRuns + 1
                gcLast = math.floor(gcSmooth * 100) / 100
            end

            function printGC()
                --ac.debug("Runtime | collectgarbage", gcLast .. " KB")
                __PURE__STATE:setString("debug.memory", gcLast .. " KB")
            end
        end

        _l_pure_loaded = true

        _l_debug_times = __PURE__get_config("debug.computation")

        _l_PURE_PILOT_TONE = RAMBackup("PURE_PILOT_TONE")
        _l_PURE_PILOT_TONE:BackupWithSet(true)
    end
    
    -- initialize the additional CSP light
    --init_lights()
--[[
    for k,v in pairs(ac) do
        ac.debug("# "..k, v)
    end
]]


    --local mesh = ac.findMeshes('{ static:yes & alphaBlend:no & transparent:no  }') --& ! lodOut:0 & ! largerThan:1
    -- color: rgbm, colorConsistency: number, thickness: number, life: number, size: number, spreadK: number, growK: number, targetYVelocity: number
    --local shot = ac.GeometryShot(mesh, vec2(1,1), 1, true, render.AntialiasingMode.None)
    --local cam_up = vec3(0,1,0)
    
    local _l_debug_time_value = 0
    local function output_time(n, part)
        if _l_smooth_times~=nil and _l_smooth_times[n]~= nil then
            local delta = os.preciseClock() - _l_debug_time_value
            _l_smooth_times[n]:set(delta*1000)
            if _l_debug_times then
                ac.debug(part, _l_smooth_times[n]:get())
            end
        end
        _l_debug_time_value = os.preciseClock()
    end




    local _l_avg_sync_fps = 0
    local _l_pp_state = ac.isPpActive()


    --local time_avg = 0
    function script.update(dt)

        if __AC_SIM~=nil and _l_pure_loaded then

            local time = os.preciseClock()

            output_time(1, "00 Pre Frame")

            --_d(frames_before_load)

            if _l_PURE_PILOT_TONE ~= nil then
                if os.clock() >= _l_PURE_PILOT_TONE_update + 0.5 then
                    _l_PURE_PILOT_TONE_update = os.clock()
                    _l_PURE_PILOT_TONE:set("time", _l_PURE_PILOT_TONE_update)
                end
            end

            PURE__SDK__UPDATE_STATES()
        
            __PURE__track_heading_angle = ac.getRealTrackHeadingAngle()

            __PURE__AC_TIME = ac.getDaySeconds()

            __PURE__update_config(dt)
            --__PURE__update_planner(dt)
            output_time(2, "01 Config")

            __PURE__update_camera(dt)
            output_time(3, "02 Camera")
            
            __PURE__update_stellar_position()
            output_time(4, "03 StellarPos")

            __PURE__update__basic__vars()
            output_time(6, "04 BasicVars")

            smoothingMgr:update(dt)
            output_time(7, "05 Smoothing")

            __PURE__update_condition(dt)
            output_time(8, "06 Condition")

            __PURE__update_track(dt)
            output_time(9, "07 Track")

            -- create all world parameters (sky, sun, moon, ambient, fog)
            __PURE__create_world(dt)
            output_time(10, "08 CreateWorld")

            __PURE__update_AI(dt)
            output_time(11, "09 AI")

            -- maybe test things
            if __PURE__update__test_ground ~= nil then
                __PURE__update__test_ground()
            end
           
            -- prepare the render/shaders, give them the chance to influence the world
            __PURE__prepare_render(dt)
            output_time(12, "10 PrepareRender")
 
            -- set all world parameters (sky, sun, moon, ambient, fog)
            __PURE__apply_world(dt)
            output_time(13, "11 ApplyWorld")

            -- update the render/shaders
            __PURE__update_render(dt)
            output_time(14, "12 UpdateRender")

            __PURE__update_Audio(dt)
            output_time(15, "13 Audio")

            --ac.debug("async", __withAsyncUpdate)
            --if __CSP_version < 1748 or not __withAsyncUpdate then
            --    script.asyncUpdate(dt)
            --end






            -- former asyncUpdate
            __PURE__async_update_world(dt)
            __PURE__async_update_render(dt)






            __Pure_State__update(dt)
            output_time(16, "14 States")

            -- update sharing variables
            __PURE__UPDATE_SHARING__(dt)
            output_time(17, "15 UpdateSharing")

            -- separation between world and receptor
            -----------------------------------------
            __PURE__apply_Exposure(dt)
            output_time(18, "16 Exposure")
            __PURE__apply_PP(dt)
            output_time(19, "17 PP")
            __PURE__update_tonemapping(dt)
            output_time(20, "18 Tonemapping")

            _l_avg_sync_fps = _l_avg_sync_fps*0.99 + (1/math.max(0.001, dt))*0.01
            --if __PURE__get_config("debug.fps") then
            --    ac.debug("FPS | _sync", string.format('%.1f', _l_avg_sync_fps))
            --end
            __PURE__STATE:setValue("fps.sync", _l_avg_sync_fps)
            __PURE__STATE:setValue("fps.async", _l_avg_sync_fps)


            if __PURE__get_config("debug.memory") then
                runGC()
                printGC()
            end

            --ac.debug(">", "current day: "..os.date('%Y-%m-%d', __AC_SIM.timestamp).." "..os.date('%H:%M:%S', __AC_SIM.timestamp))
            --shot:update(__PURE__camPos, __PURE__sunDir, cam_up, 1)
            --ac.debug("##", shot:depth())
        


            --local UI = ac.getUI()
            --UI:


            --PURE_ERR_update(dt)

            --time_avg = time_avg*(1-dt) + (os.preciseClock()-time)*dt
            --_d(time_avg * 1000)

            local time_diff = os.preciseClock() - time
            __execution_time_long:set(time_diff)
            --ac.debug("##1", __execution_time_long:get())
            __execution_time_short:set(time_diff)
            --ac.debug("##2", __execution_time_short:get())

            if __AC_SIM.isInMainMenu then
                _l_menu_open = true
            else
                _l_menu_open = false
            end
            _l_debug_time_value = os.preciseClock()
        else
            __AC_SIM = ac.getSim()
            if __AC_SIM~=nil then
                if __AC_SIM.isPostProcessingActive == ac.isPpActive() then
                    load_pure()
                end
            else
                frames_before_load = frames_before_load + 1
            end
        end
    end

else

    dofile (__pure__path.."\\utils\\utils_wrongCSP.lua")

    function update(dt)
        show_incompatible_CSP_version(--[[__CSP__minimum_version]])
    end
end



---Functions from this list will be called when resolution changes.
---@type fun()[]
OnResolutionChange = {}

-- To stop script from reloading with resolution changes, adding a subscription to the event
ac.onResolutionChange(function (newSize, makingScreenshot)
    ac.log('Resolution change', newSize, makingScreenshot)
  
    -- Instead of manually disposing all created textures, the idea is to clear out all the tables
    -- containing those and then run garbage collector and let CSP clean things up automatically
    for _, v in ipairs(OnResolutionChange) do v() end
    collectgarbage('collect')
end)
